﻿using System;
using System.Collections.Generic;
using System.Windows;

namespace Microscopic_Traffic_Simulator___Model.GeometricObjects.Lanes
{
    /// <summary>
    /// Represents single straight lane.
    /// </summary>
    [Serializable]
    public class StraightLane : Lane
    {
        /// <summary>
        /// Constructor of straight lane.
        /// </summary>
        /// <param name="startPoint">Location of input end.</param>
        /// <param name="endPoint">Location of output end.</param>
        public StraightLane(Point startPoint, Point endPoint) : base(startPoint, endPoint) { }

        /// <summary>
        /// Get lane points.
        /// </summary>
        /// <param name="lanePointsMaxDistance">The maximum distance between lane points.</param>
        /// <returns>Location of lane points.</returns>
        internal override IEnumerable<Point> LanePoints(double lanePointsMaxDistance)
        {
            //Get vector from start point to end point.
            Vector startToEndVector = endNode.Location - startNode.Location;
            //Get vector from one lane point to other lane point 
            Vector cellStartToEndVector = startToEndVector;
            cellStartToEndVector.Normalize();
            cellStartToEndVector *= lanePointsMaxDistance;
            //Get count of points which will be returned.
            int lanePointsCount = (int)(startToEndVector.Length / cellStartToEndVector.Length) + 1;
            //Go through the lane and return points.
            Point currentPoint = startNode.Location;
            for (int i = 0; i < lanePointsCount; i++)
            {
                yield return currentPoint;
                currentPoint += cellStartToEndVector;
            }
            //Return end point location as the additional lane point if it was not returned in the loop above.
            if (currentPoint != endNode.Location)
            {
                yield return endNode.Location;
            }
        }
    }
}
